﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BSDKW;

namespace SampleMapApplication
{
    public partial class Credentials : Form
    {
        BDataLoader _bDataLoader;
        public Credentials(BDataLoader bDataLoader)
        {
            InitializeComponent();
            _bDataLoader = bDataLoader;
        }

        /// <summary>
        /// Generates the connection string to authenticate the credentials from urbex.
        /// </summary>
        private string GetConnectionString()
        {
            return "BlomURBEX3DServer:" + userName.Text + ":" + password.Text;
        }

        private void ok_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(userName.Text) || string.IsNullOrWhiteSpace(password.Text))
            {
                //If the username or password is not provided, then ask the user to provide one.
                MessageBox.Show("Username or password should have some value.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                //Authenticate the credentials.
                BLerror oResult = _bDataLoader.AddDataSource(0, GetConnectionString());

                //If the credentials are authenticated then just close the form and continue; else show error.
                if (oResult == BLerror.BL_SUCCESS)
                {
                    DialogResult = DialogResult.OK;
                    this.Close();
                }
                else
                {
                    MessageBox.Show("Authentication failed, please try again.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }
    }
}
